/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model;

import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.HeightGameMap;
import technology.rocketjump.undermount.mapgen.model.HeightmapVertex;

public class VertexGameMap
extends AbstractGameMap {
    private final int numTilesWide;
    private final int numTilesHigh;
    private Array<Array<HeightmapVertex>> heightMap;

    public VertexGameMap(int numTilesWide, int numTilesHigh) {
        super(numTilesWide, numTilesHigh);
        this.numTilesWide = numTilesWide;
        this.numTilesHigh = numTilesHigh;
        this.heightMap = new Array(numTilesWide + 1);
        for (int x = 0; x <= numTilesWide; ++x) {
            Array<HeightmapVertex> yArray = new Array<HeightmapVertex>(numTilesHigh + 1);
            for (int y = 0; y <= numTilesHigh; ++y) {
                yArray.add(new HeightmapVertex());
            }
            this.heightMap.add(yArray);
        }
    }

    public int getNumTilesWide() {
        return this.numTilesWide;
    }

    public int getNumTilesHigh() {
        return this.numTilesHigh;
    }

    public HeightmapVertex get(int x, int y) {
        if (x < 0 || x > this.numTilesWide) {
            return null;
        }
        if (y < 0 || y > this.numTilesHigh) {
            return null;
        }
        return this.heightMap.get(x).get(y);
    }

    public void set(int x, int y, float height) {
        if (x >= 0 && x <= this.numTilesWide && y >= 0 && y <= this.numTilesHigh) {
            this.heightMap.get(x).get(y).setHeight(height);
        }
    }

    public void normalise() {
        float heightAtPoint;
        int y;
        int x;
        float minHeight = Float.MAX_VALUE;
        float maxHeight = Float.MIN_VALUE;
        for (x = 0; x <= this.numTilesWide; ++x) {
            for (y = 0; y <= this.numTilesHigh; ++y) {
                heightAtPoint = this.get(x, y).getHeight();
                if (heightAtPoint < minHeight) {
                    minHeight = heightAtPoint;
                }
                if (!(heightAtPoint > maxHeight)) continue;
                maxHeight = heightAtPoint;
            }
        }
        for (x = 0; x <= this.numTilesWide; ++x) {
            for (y = 0; y <= this.numTilesHigh; ++y) {
                heightAtPoint = this.get(x, y).getHeight();
                float adjusted = (heightAtPoint - minHeight) / (maxHeight - minHeight);
                this.set(x, y, adjusted);
            }
        }
    }

    public void setAverageOfDiamond(int x, int y) {
        float totalHeightNeighbours = 0.0f;
        float numNeigbours = 0.0f;
        HeightmapVertex neighbour = this.get(x - 1, y);
        if (neighbour != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x + 1, y)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x, y - 1)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x, y + 1)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        float average = totalHeightNeighbours / numNeigbours;
        this.set(x, y, average);
    }

    public void setAverageOfSquare(int x, int y) {
        float totalHeightNeighbours = 0.0f;
        float numNeigbours = 0.0f;
        HeightmapVertex neighbour = this.get(x - 1, y - 1);
        if (neighbour != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x + 1, y - 1)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x - 1, y + 1)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        if ((neighbour = this.get(x + 1, y + 1)) != null) {
            totalHeightNeighbours += neighbour.getHeight();
            numNeigbours += 1.0f;
        }
        float average = totalHeightNeighbours / numNeigbours;
        this.set(x, y, average);
    }

    public HeightGameMap toHeightMap() {
        HeightGameMap result = new HeightGameMap(this.numTilesWide, this.numTilesHigh);
        for (int x = 0; x < this.numTilesWide; ++x) {
            for (int y = 0; y < this.numTilesHigh; ++y) {
                result.setHeight(x, y, this.average(x, y));
            }
        }
        result.normalise();
        return result;
    }

    private float average(int x, int y) {
        return (this.get(x, y).getHeight() + this.get(x + 1, y).getHeight() + this.get(x, y + 1).getHeight() + this.get(x + 1, y + 1).getHeight()) / 4.0f;
    }

    public VertexGameMap crop(int offsetX, int offsetY, int targetWidth, int targetHeight) {
        VertexGameMap result = new VertexGameMap(targetWidth, targetHeight);
        for (int x = offsetX; x < offsetX + targetWidth + 1; ++x) {
            for (int y = offsetY; y < offsetY + targetHeight + 1; ++y) {
                result.set(x - offsetX, y - offsetY, this.get(x, y).getHeight());
            }
        }
        result.normalise();
        return result;
    }
}

